<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'ReplyPilot')); ?> - Inbox</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

<style>


        a:hover {
            text-decoration: none !important;
        }

        a {
            text-decoration: none !important;
        }
    </style>

</head>
<body class="font-sans antialiased bg-gray-100">
    <div class="min-h-screen">
        <!-- Navigation -->
        <nav class="bg-white shadow">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8" style="max-width: 1280px; margin-left: auto; margin-right: auto; width: 100%;">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <h1 class="text-xl font-semibold text-gray-900">ReplyPilot</h1>
                    </div>
                    <div class="flex items-center space-x-4">
                        <a href="<?php echo e(route('dashboard')); ?>" class="text-gray-700 hover:text-gray-900">Dashboard</a>
                        <a href="<?php echo e(\App\Helpers\RoleBasedNavigation::getReviewsIndexRoute()); ?>" class="text-gray-700 hover:text-gray-900">Reviews</a>
                        <a href="<?php echo e(\App\Helpers\RoleBasedNavigation::getEmailIndexRoute()); ?>" class="text-indigo-600 font-medium">Inbox</a>
                        <a href="<?php echo e(route('email.accounts')); ?>" class="text-gray-700 hover:text-gray-900">Accounts</a>
                        <form method="POST" action="<?php echo e(route('logout')); ?>" class="inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="text-gray-700 hover:text-gray-900">Logout</button>
                        </form>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8" style="max-width: 1280px; margin-left: auto; margin-right: auto; width: 100%;">
            <?php if(session('success')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="px-4 py-6 sm:px-0">
                <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center mb-6 gap-4">
                    <h2 class="text-lg sm:text-xl font-bold text-gray-900">Email Inbox <!-- v1.1 HTML-Fixed --></h2>
                    <div class="flex flex-wrap items-center gap-2">
                        <?php if($threads->count() > 0): ?>
                            <button type="button"
                                    class="bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-3 rounded text-xs sm:text-sm"
                                    onclick="bulkDeleteSelected()"
                                    id="bulkDeleteBtn"
                                    disabled>
                                Delete Selected
                            </button>
                        <?php endif; ?>
                        <!-- Account Filter -->
                        <?php if($mailAccounts->count() > 1): ?>
                            <form method="GET" action="<?php echo e(route('email.index')); ?>" class="inline">
                                <?php echo csrf_field(); ?>
                                <select name="account" onchange="this.form.submit()"
                                        class="border border-gray-300 rounded-md px-1 py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 max-w-[120px] sm:max-w-none">
                                    <option value="all" <?php echo e(request('account') === 'all' || !request('account') ? 'selected' : ''); ?>>All Accounts</option>
                                    <?php $__currentLoopData = $mailAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($account->id); ?>" <?php echo e(request('account') == $account->id ? 'selected' : ''); ?>>
                                            <?php echo e($account->email); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </form>
                        <?php endif; ?>

                        <!-- Account Management -->
                        <a href="<?php echo e(route('email.accounts')); ?>"
                           class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-3 rounded text-xs sm:text-sm">
                            <span class="hidden sm:inline">Manage Accounts</span>
                            <span class="sm:hidden">Accounts</span>
                        </a>

                        <!-- Fetch Emails -->
                        <form method="POST" action="<?php echo e(route('email.ingest')); ?>" class="inline flex items-center gap-1">
                            <?php echo csrf_field(); ?>
                            <?php if($mailAccounts->count() > 1): ?>
                                <select name="account_id"
                                        class="border border-gray-300 rounded-md px-1 py-2 text-xs sm:text-sm max-w-[100px] sm:max-w-none">
                                    <?php $__currentLoopData = $mailAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($account->id); ?>" <?php echo e($account->is_primary ? 'selected' : ''); ?>>
                                            <?php echo e($account->email); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            <?php elseif($mailAccounts->count() == 1): ?>
                                <!-- Hidden input for single account -->
                                <input type="hidden" name="account_id" value="<?php echo e($mailAccounts->first()->id); ?>" x-ref="accountSelect">
                            <?php endif; ?>
                            <button type="submit"
                                    class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-3 rounded text-xs sm:text-sm flex items-center"
                                    onclick="this.disabled=true; this.innerHTML='<svg class=\'animate-spin -ml-1 mr-3 h-5 w-5 text-white\' xmlns=\'http://www.w3.org/2000/svg\' fill=\'none\' viewBox=\'0 0 24 24\'><circle class=\'opacity-25\' cx=\'12\' cy=\'12\' r=\'10\' stroke=\'currentColor\' stroke-width=\'4\'></circle><path class=\'opacity-75\' fill=\'currentColor\' d=\'M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z\'></path></svg>Fetching...'; this.form.submit();">
                                <span class="hidden sm:inline">Fetch Emails</span>
                                <span class="sm:hidden">Fetch</span>
                            </button>
                        </form>
                    </div>
                </div>

                <?php if($threads->count() > 0): ?>
                    <div class="bg-white shadow overflow-hidden sm:rounded-md">
                        <div class="px-6 py-3 bg-gray-50 border-b border-gray-200">
                            <div class="flex items-center">
                                <input type="checkbox"
                                       id="masterCheckbox"
                                       class="rounded border-gray-300 text-red-600 focus:ring-red-500"
                                       onchange="toggleAllThreads()">
                                <label for="masterCheckbox" class="ml-2 text-sm font-medium text-gray-700">
                                    Select All Threads
                                </label>
                            </div>
                        </div>
                        <ul class="divide-y divide-gray-200 email-list-mobile">
                            <?php $__currentLoopData = $threads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $thread): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="px-6 py-4 email-item-mobile">
                                    <div class="flex items-start justify-between">
                                        <div class="flex-shrink-0 pt-1 mr-3">
                                            <input type="checkbox"
                                                   class="thread-checkbox rounded border-gray-300 text-red-600 focus:ring-red-500"
                                                   value="<?php echo e($thread->id); ?>"
                                                   onchange="updateBulkDeleteButton()">
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <div class="flex flex-col sm:flex-row sm:items-start sm:justify-between gap-4">
                                                <div class="min-w-0 flex-1">
                                                    <div class="flex flex-wrap items-center gap-2 mb-2">
                                                <h3 class="text-sm font-medium text-gray-900 break-words"><?php echo e($thread->subject); ?></h3>
                                                <span class="text-xs sm:text-sm text-gray-500"><?php echo e($thread->last_message_at->format('M d, Y H:i')); ?></span>
                                                <?php if($thread->mailAccount): ?>
                                                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800 truncate max-w-[150px] sm:max-w-none">
                                                        <?php echo e($thread->mailAccount->email); ?>

                                                    </span>
                                                <?php endif; ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                                    <?php if($thread->status === 'open'): ?> bg-green-100 text-green-800
                                                    <?php elseif($thread->status === 'waiting'): ?> bg-yellow-100 text-yellow-800
                                                    <?php else: ?> bg-gray-100 text-gray-800
                                                    <?php endif; ?>">
                                                    <?php echo e(ucfirst($thread->status)); ?>

                                                </span>
                                            </div>

                                            <?php if($thread->messages->count() > 0): ?>
                                                <?php
                                                    $latestMessage = $thread->messages->sortByDesc('created_at')->first();
                                                    $source = $latestMessage->body_html
                                                        ?: $latestMessage->body_text
                                                        ?: $latestMessage->snippet
                                                        ?: '';
                                                    $decoded = html_entity_decode($source, ENT_QUOTES | ENT_HTML5, 'UTF-8');
                                                    $rawText = strip_tags($decoded);
                                                    $rawText = preg_replace('/\s+/', ' ', $rawText);

                                                    $text = preg_replace('/<(script|style)[\s\S]*?>[\s\S]*?<\/\1>/i', '', $decoded);
                                                    $text = preg_replace('/@media[^{]+\{[^}]*\}/i', '', $text);
                                                    $text = preg_replace('/[#.][A-Za-z0-9_-]+\s*\{[^}]*\}/', '', $text);
                                                    $text = strip_tags($text);
                                                    $text = preg_replace('/\s+/', ' ', $text);
                                                    $emailContent = trim($text);
                                                    $isLongContent = \Illuminate\Support\Str::length($emailContent) > 150;
                                                ?>
                                                <p class="text-sm text-gray-600 mb-2 text-left">
                                                    <strong>From:</strong> <?php echo e($latestMessage->from_addr); ?>

                                                </p>

                                                <?php if($latestMessage): ?>
                                                    <?php
                                                        $hasPreview = $emailContent !== '';
                                                    ?>
                                                    <div class="mt-2 text-left">
                                                        <!-- Preview (truncated) -->
                                                        <div id="email-preview-<?php echo e($thread->id); ?>" class="text-sm text-gray-500 text-left">
                                                            <div id="preview-text-<?php echo e($thread->id); ?>" class="text-left">
                                                                <?php echo e($hasPreview ? ($isLongContent ? \Illuminate\Support\Str::limit($emailContent, 150) : $emailContent) : 'Preview unavailable.'); ?>

                                                            </div>

                                                            <button type="button"
                                                                    class="text-blue-600 hover:text-blue-800 text-xs mt-1 bg-blue-100 px-2 py-1 rounded text-left"
                                                                    onclick="toggleEmailContent('<?php echo e($thread->id); ?>')"
                                                                    id="toggle-btn-<?php echo e($thread->id); ?>">
                                                                Read More
                                                            </button>
                                                        </div>

                                                        <!-- Full Email Content (Hidden by default) -->
                                                        <div id="email-full-<?php echo e($thread->id); ?>" class="hidden mt-2 text-sm text-gray-700 bg-gray-50 p-3 rounded text-left">
                                                            <?php if($latestMessage->body_html): ?>
                                                                <?php
                                                                    $raw = $latestMessage->body_html;
                                                                    $safe = preg_replace('/<(script|style)[\s\S]*?>[\s\S]*?<\/\1>/i', '', $raw);
                                                                    $safe = preg_replace('/<head[\s\S]*?>[\s\S]*?<\/head>/i', '', $safe);
                                                                    $safe = preg_replace('/<\/?(html|body)[^>]*>/i', '', $safe);
                                                                    $safe = preg_replace('/<(meta|link|title)[\s\S]*?>/i', '', $safe);
                                                                    $safeWrapped = '<div style="font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif; font-size:14px; color:#111827; line-height:1.4;">'
                                                                        . $safe .
                                                                        '</div>';
                                                                    $srcdoc = str_replace('"', '&quot;', $safeWrapped);
                                                                ?>
                                                                <iframe
                                                                    class="w-full bg-white rounded border"
                                                                    sandbox="allow-same-origin"
                                                                    scrolling="yes"
                                                                    srcdoc="<?php echo $srcdoc; ?>"
                                                                    onload="resizeEmailIframe(this)"
                                                                ></iframe>
                                                            <?php elseif($latestMessage->body_text): ?>
                                                                <?php
                                                                    $plainText = e($latestMessage->body_text);
                                                                    $plainText = preg_replace(
                                                                        '/(https?:\/\/[^\s<]+)/i',
                                                                        '<a href="$1" class="text-blue-600 underline" target="_blank" rel="noopener noreferrer">$1</a>',
                                                                        $plainText
                                                                    );
                                                                    $plainText = nl2br($plainText);
                                                                ?>
                                                                <div class="text-left">
                                                                    <?php echo $plainText; ?>

                                                                </div>
                                                            <?php else: ?>
                                                                <?php
                                                                    $snippetText = e($latestMessage->snippet);
                                                                    $snippetText = preg_replace(
                                                                        '/(https?:\/\/[^\s<]+)/i',
                                                                        '<a href="$1" class="text-blue-600 underline" target="_blank" rel="noopener noreferrer">$1</a>',
                                                                        $snippetText
                                                                    );
                                                                    $snippetText = nl2br($snippetText);
                                                                ?>
                                                                <div class="text-left">
                                                                    <?php echo $snippetText; ?>

                                                                </div>
                                                            <?php endif; ?>
                                                            <button type="button"
                                                                    class="text-blue-600 hover:text-blue-800 text-xs mt-2 bg-blue-100 px-2 py-1 rounded text-left"
                                                                    onclick="toggleEmailContent('<?php echo e($thread->id); ?>')"
                                                                    id="toggle-btn-full-<?php echo e($thread->id); ?>">
                                                                Show Less
                                                            </button>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if($thread->emailDrafts->count() > 0): ?>
                                                <?php
                                                    $latestDraft = $thread->emailDrafts->sortByDesc('created_at')->first();
                                                    $draftContent = strip_tags($latestDraft->draft_html, '<p><br><strong><em><u>');
                                                    $isDraftLong = \Illuminate\Support\Str::length(strip_tags($draftContent)) > 200;
                                                ?>
                                                <div class="mt-2 p-3 bg-gray-50 rounded-md text-left">
                                                    <p class="text-sm text-gray-700 text-left"><strong>Draft Reply:</strong></p>

                                                    <?php if($isDraftLong): ?>
                                                        <!-- Draft Preview (truncated) -->
                                                        <div id="draft-preview-<?php echo e($thread->id); ?>" class="text-sm text-gray-600 text-left">
                                                            <div class="text-left"><?php echo Str::limit($draftContent, 200); ?></div>
                                                            <button type="button"
                                                                    class="text-blue-600 hover:text-blue-800 text-xs mt-1 bg-blue-100 px-2 py-1 rounded text-left"
                                                                    onclick="toggleDraftContent('<?php echo e($thread->id); ?>')"
                                                                    id="toggle-draft-btn-<?php echo e($thread->id); ?>">
                                                                Read More
                                                            </button>
                                                        </div>

                                                        <!-- Full Draft Content (Hidden by default) -->
                                                        <div id="draft-full-<?php echo e($thread->id); ?>" class="hidden text-sm text-gray-600 text-left">
                                                            <div class="text-left"><?php echo $latestDraft->draft_html; ?></div>
                                                            <button type="button"
                                                                    class="text-blue-600 hover:text-blue-800 text-xs mt-2 bg-blue-100 px-2 py-1 rounded text-left"
                                                                    onclick="toggleDraftContent('<?php echo e($thread->id); ?>')"
                                                                    id="toggle-draft-btn-full-<?php echo e($thread->id); ?>">
                                                                Show Less
                                                            </button>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="text-sm text-gray-600 text-left">
                                                            <div class="text-left"><?php echo $latestDraft->draft_html; ?></div>
                                                        </div>
                                                    <?php endif; ?>

                                                    <?php if($latestDraft->ai_meta['escalate'] ?? false): ?>
                                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800 mt-2">
                                                            Escalation Required
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endif; ?>
                                                </div>
                                                <div class="flex flex-wrap items-center justify-end gap-2 w-full sm:w-auto">
                                            <?php if($thread->emailDrafts->count() === 0): ?>
                                                <form method="POST" action="<?php echo e(route('email.draft', $thread)); ?>" class="inline"
                                                      onsubmit="return handleDraftSubmit(this, '<?php echo e($thread->id); ?>')">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" id="draft-btn-<?php echo e($thread->id); ?>"
                                                            class="bg-indigo-500 hover:bg-indigo-700 text-white font-bold py-1 px-3 rounded text-sm flex items-center">
                                                        <svg id="draft-icon-<?php echo e($thread->id); ?>" class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                                                        </svg>
                                                        <span id="draft-text-<?php echo e($thread->id); ?>">AI Draft</span>
                                                    </button>
                                                </form>
                                            <?php endif; ?>

                                            <?php if($thread->emailDrafts->count() > 0): ?>
                                                <?php $latestDraft = $thread->emailDrafts->sortByDesc('created_at')->first(); ?>
                                                <?php if($latestDraft->status === 'pending'): ?>
                                                    <a href="<?php echo e(route('email.draft.edit', $latestDraft)); ?>"
                                                       class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-1 px-2 sm:px-3 rounded text-xs sm:text-sm no-underline inline-flex items-center">
                                                        <svg class="w-4 h-4 sm:mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                                        </svg>
                                                        <span class="ml-1">Edit Draft</span>
                                                    </a>
                                                    <form method="POST" action="<?php echo e(route('email.approve', $latestDraft)); ?>" class="inline"
                                                          onsubmit="return handleApproveSubmit(this, '<?php echo e($latestDraft->id); ?>')">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" id="approve-btn-<?php echo e($latestDraft->id); ?>"
                                                                class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-3 rounded text-sm flex items-center">
                                                            <svg id="approve-icon-<?php echo e($latestDraft->id); ?>" class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                                                            </svg>
                                                            <span id="approve-text-<?php echo e($latestDraft->id); ?>">Approve & Send</span>
                                                        </button>
                                                    </form>
                                                    <form method="POST" action="<?php echo e(route('email.draft.delete', $latestDraft)); ?>" class="inline"
                                                          onsubmit="return handleDeleteDraftSubmit(this, '<?php echo e($latestDraft->id); ?>')">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" id="delete-draft-btn-<?php echo e($latestDraft->id); ?>"
                                                                class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded text-sm flex items-center">
                                                            <svg id="delete-draft-icon-<?php echo e($latestDraft->id); ?>" class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                            </svg>
                                                            <span id="delete-draft-text-<?php echo e($latestDraft->id); ?>">Delete Draft</span>
                                                        </button>
                                                    </form>
                                                <?php elseif($latestDraft->status === 'sent'): ?>
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                        Sent
                                                    </span>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                                <form method="POST" action="<?php echo e(\App\Helpers\RoleBasedNavigation::getThreadDeleteRoute($thread)); ?>" class="inline"
                                                      onsubmit="return handleDeleteThreadSubmit(this, '<?php echo e($thread->id); ?>')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" id="delete-thread-btn-<?php echo e($thread->id); ?>"
                                                            class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-1 px-3 rounded text-sm flex items-center">
                                                        <svg id="delete-thread-icon-<?php echo e($thread->id); ?>" class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                        </svg>
                                                        <span id="delete-thread-text-<?php echo e($thread->id); ?>">Delete Thread</span>
                                                    </button>
                                                </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>

                    <div class="mt-4">
                        <?php echo e($threads->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="text-center py-12">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900">No email threads</h3>
                        <p class="mt-1 text-sm text-gray-500">Use the "Fetch Emails" button above to get started.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        function updateBulkDeleteButton() {
            const checkboxes = document.querySelectorAll('.thread-checkbox');
            const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');
            const masterCheckbox = document.getElementById('masterCheckbox');
            const checkedCount = document.querySelectorAll('.thread-checkbox:checked').length;
            const totalCount = checkboxes.length;

            // Update master checkbox state
            if (masterCheckbox) {
                if (checkedCount === 0) {
                    masterCheckbox.checked = false;
                    masterCheckbox.indeterminate = false;
                } else if (checkedCount === totalCount) {
                    masterCheckbox.checked = true;
                    masterCheckbox.indeterminate = false;
                } else {
                    masterCheckbox.checked = false;
                    masterCheckbox.indeterminate = true;
                }
            }

            // Update bulk delete button
            if (checkedCount > 0) {
                bulkDeleteBtn.disabled = false;
                bulkDeleteBtn.textContent = `Delete Selected (${checkedCount})`;
            } else {
                bulkDeleteBtn.disabled = true;
                bulkDeleteBtn.textContent = 'Delete Selected';
            }
        }

        function bulkDeleteSelected() {
            const checkboxes = document.querySelectorAll('.thread-checkbox:checked');
            const threadIds = Array.from(checkboxes).map(cb => cb.value);


            if (threadIds.length === 0) {
                alert('No threads selected for deletion.');
                return;
            }

            const confirmMessage = `Are you sure you want to delete ${threadIds.length} email thread(s)? This will delete all messages and drafts. This action cannot be undone.`;

            if (confirm(confirmMessage)) {
                // Create form and submit
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = '<?php echo e(\App\Helpers\RoleBasedNavigation::getBulkDeleteRoute()); ?>';
                form.style.display = 'none';


                // Add CSRF token
                const csrfToken = document.createElement('input');
                csrfToken.type = 'hidden';
                csrfToken.name = '_token';
                csrfToken.value = '<?php echo e(csrf_token()); ?>';
                form.appendChild(csrfToken);

                // Add thread IDs
                threadIds.forEach(id => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'thread_ids[]';
                    input.value = id;
                    form.appendChild(input);
                });


                document.body.appendChild(form);
                form.submit();
            }
        }

        function toggleAllThreads() {
            const masterCheckbox = document.getElementById('masterCheckbox');
            const checkboxes = document.querySelectorAll('.thread-checkbox');

            checkboxes.forEach(checkbox => {
                checkbox.checked = masterCheckbox.checked;
            });

            updateBulkDeleteButton();
        }

        // Button handlers for Alpine.js replacement
        function handleDraftSubmit(form, threadId) {
            const button = document.getElementById(`draft-btn-${threadId}`);
            const icon = document.getElementById(`draft-icon-${threadId}`);
            const text = document.getElementById(`draft-text-${threadId}`);

            // Show loading state
            button.disabled = true;
            button.classList.add('opacity-50');
            text.textContent = 'Generating...';

            // Add spinner
            icon.innerHTML = '<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>';
            icon.classList.add('animate-spin');

            return true;
        }

        function handleApproveSubmit(form, draftId) {
            if (!confirm('Are you sure you want to send this email?')) {
                return false;
            }

            const button = document.getElementById(`approve-btn-${draftId}`);
            const icon = document.getElementById(`approve-icon-${draftId}`);
            const text = document.getElementById(`approve-text-${draftId}`);

            // Show loading state
            button.disabled = true;
            button.classList.add('opacity-50');
            text.textContent = 'Sending...';

            // Add spinner
            icon.innerHTML = '<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>';
            icon.classList.add('animate-spin');

            return true;
        }

        function handleDeleteDraftSubmit(form, draftId) {
            if (!confirm('Are you sure you want to delete this draft? This action cannot be undone.')) {
                return false;
            }

            const button = document.getElementById(`delete-draft-btn-${draftId}`);
            const icon = document.getElementById(`delete-draft-icon-${draftId}`);
            const text = document.getElementById(`delete-draft-text-${draftId}`);

            // Show loading state
            button.disabled = true;
            button.classList.add('opacity-50');
            text.textContent = 'Deleting...';

            // Add spinner
            icon.innerHTML = '<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>';
            icon.classList.add('animate-spin');

            return true;
        }

        function handleDeleteThreadSubmit(form, threadId) {
            if (!confirm('Are you sure you want to delete this entire email thread? This will delete all messages and drafts. This action cannot be undone.')) {
                return false;
            }

            const button = document.getElementById(`delete-thread-btn-${threadId}`);
            const icon = document.getElementById(`delete-thread-icon-${threadId}`);
            const text = document.getElementById(`delete-thread-text-${threadId}`);

            // Show loading state
            button.disabled = true;
            button.classList.add('opacity-50');
            text.textContent = 'Deleting...';

            // Add spinner
            icon.innerHTML = '<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>';
            icon.classList.add('animate-spin');

            return true;
        }

        function resizeEmailIframe(iframe) {
            try {
                const doc = iframe.contentDocument || iframe.contentWindow.document;
                const resize = () => {
                    const height = doc.documentElement.scrollHeight || doc.body.scrollHeight;
                    iframe.style.height = Math.max(height + 20, 200) + 'px';
                };
                setTimeout(resize, 50);
                setTimeout(resize, 300);
                setTimeout(resize, 1000);
            } catch (e) {
                iframe.style.height = '350px';
            }
        }

        // Toggle email content visibility
        function toggleEmailContent(threadId) {
            const preview = document.getElementById(`email-preview-${threadId}`);
            const fullContent = document.getElementById(`email-full-${threadId}`);

            if (fullContent.classList.contains('hidden')) {
                // Show full content
                preview.classList.add('hidden');
                fullContent.classList.remove('hidden');
            } else {
                // Show preview
                preview.classList.remove('hidden');
                fullContent.classList.add('hidden');
            }
        }

        // Toggle draft content visibility
        function toggleDraftContent(threadId) {
            const preview = document.getElementById(`draft-preview-${threadId}`);
            const fullContent = document.getElementById(`draft-full-${threadId}`);

            if (fullContent.classList.contains('hidden')) {
                // Show full content
                preview.classList.add('hidden');
                fullContent.classList.remove('hidden');
            } else {
                // Show preview
                preview.classList.remove('hidden');
                fullContent.classList.add('hidden');
            }
        }
    </script>
</body>
</html>

<?php /**PATH C:\Users\iyall\OneDrive\Documents\AI\claude\replypilot\resources\views/email/index.blade.php ENDPATH**/ ?>