<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'ReplyPilot') }} - Tenant Admin Settings</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        a:hover { text-decoration: none !important; }
        a { text-decoration: none !important; }
    </style>
</head>
<body class="font-sans antialiased bg-gray-100">
    <div class="min-h-screen">
        <!-- Navigation -->
        <nav class="bg-white shadow">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <h1 class="text-lg sm:text-xl font-semibold text-gray-900">ReplyPilot</h1>
                    </div>

                    <!-- Mobile menu button -->
                    <div class="flex items-center md:hidden">
                        <button type="button" onclick="toggleMobileMenu()" class="inline-flex items-center justify-center p-2 rounded-md text-gray-700 hover:text-gray-900 hover:bg-gray-100">
                            <svg id="menu-icon" class="block h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                            <svg id="close-icon" class="hidden h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>

                    <!-- Desktop navigation -->
                    <div class="hidden md:flex md:items-center md:space-x-4">
                        <a href="{{ route('dashboard') }}" class="text-gray-700 hover:text-gray-900 text-sm">Dashboard</a>
                        <a href="{{ route('tenant-admin.reviews.index') }}" class="text-gray-700 hover:text-gray-900 text-sm">Reviews</a>
                        <a href="{{ route('tenant-admin.email.index') }}" class="text-gray-700 hover:text-gray-900 text-sm">Inbox</a>
                        <a href="{{ route('email.accounts') }}" class="text-gray-700 hover:text-gray-900 text-sm">Accounts</a>
                        <a href="{{ route('tenant-admin.user-management.index') }}" class="text-gray-700 hover:text-gray-900 text-sm">Users</a>
                        <a href="{{ route('tenant-admin.settings.index') }}" class="text-indigo-600 font-medium text-sm">Settings</a>
                        <form method="POST" action="{{ route('logout') }}" class="inline">
                            @csrf
                            <button type="submit" class="text-gray-700 hover:text-gray-900 text-sm">Logout</button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Mobile menu -->
            <div id="mobile-menu" class="hidden md:hidden">
                <div class="px-2 pt-2 pb-3 space-y-1 bg-gray-50 border-t">
                    <a href="{{ route('dashboard') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Dashboard</a>
                    <a href="{{ route('tenant-admin.reviews.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Reviews</a>
                    <a href="{{ route('tenant-admin.email.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Inbox</a>
                    <a href="{{ route('email.accounts') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Accounts</a>
                    <a href="{{ route('tenant-admin.user-management.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">User Management</a>
                    <a href="{{ route('tenant-admin.settings.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-indigo-600 bg-indigo-50">Settings</a>
                    <form method="POST" action="{{ route('logout') }}" class="block">
                        @csrf
                        <button type="submit" class="w-full text-left px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Logout</button>
                    </form>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
            @if (session('success'))
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    {{ session('error') }}
                </div>
            @endif

            <div class="px-4 py-6 sm:px-0">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Tenant Admin Settings</h2>

                <!-- Auto-Ingestion Settings Card -->
                <div class="bg-white shadow rounded-lg p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Auto-Ingestion Intervals</h3>
                    <p class="text-sm text-gray-600 mb-6">Configure how often the system automatically fetches new emails and reviews for your organization.</p>

                    <form method="POST" action="{{ route('tenant-admin.settings.update-ingestion-interval') }}">
                        @csrf

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Email Ingestion Interval -->
                            <div>
                                <label for="email_interval" class="block text-sm font-medium text-gray-700 mb-2">
                                    Email Auto-Ingestion Interval
                                </label>
                                <select name="email_interval"
                                        id="email_interval"
                                        class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"
                                        onchange="toggleCustomInput('email')">
                                    @php
                                        $tenantSettings = auth()->user()->tenant->settings ?? [];
                                        $currentEmailInterval = $tenantSettings['email_ingestion_interval'] ?? 15;
                                    @endphp
                                    <option value="5" {{ $currentEmailInterval == 5 ? 'selected' : '' }}>5 minutes</option>
                                    <option value="10" {{ $currentEmailInterval == 10 ? 'selected' : '' }}>10 minutes</option>
                                    <option value="15" {{ $currentEmailInterval == 15 ? 'selected' : '' }}>15 minutes</option>
                                    <option value="30" {{ $currentEmailInterval == 30 ? 'selected' : '' }}>30 minutes</option>
                                    <option value="45" {{ $currentEmailInterval == 45 ? 'selected' : '' }}>45 minutes</option>
                                    <option value="60" {{ $currentEmailInterval == 60 ? 'selected' : '' }}>1 hour</option>
                                    <option value="custom" {{ !in_array($currentEmailInterval, [5,10,15,30,45,60]) ? 'selected' : '' }}>Custom</option>
                                </select>

                                <div id="email_custom_input" class="mt-2 {{ in_array($currentEmailInterval, [5,10,15,30,45,60]) ? 'hidden' : '' }}">
                                    <input type="number"
                                           name="email_custom_interval"
                                           id="email_custom_interval"
                                           min="1"
                                           max="1440"
                                           value="{{ !in_array($currentEmailInterval, [5,10,15,30,45,60]) ? $currentEmailInterval : '' }}"
                                           placeholder="Enter minutes (1-1440)"
                                           class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    <p class="text-xs text-gray-500 mt-1">Enter interval in minutes (1-1440)</p>
                                </div>
                            </div>

                            <!-- Review Ingestion Interval -->
                            <div>
                                <label for="review_interval" class="block text-sm font-medium text-gray-700 mb-2">
                                    Review Auto-Ingestion Interval
                                </label>
                                <select name="review_interval"
                                        id="review_interval"
                                        class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"
                                        onchange="toggleCustomInput('review')">
                                    @php
                                        $currentReviewInterval = $tenantSettings['review_ingestion_interval'] ?? 60;
                                    @endphp
                                    <option value="5" {{ $currentReviewInterval == 5 ? 'selected' : '' }}>5 minutes</option>
                                    <option value="10" {{ $currentReviewInterval == 10 ? 'selected' : '' }}>10 minutes</option>
                                    <option value="15" {{ $currentReviewInterval == 15 ? 'selected' : '' }}>15 minutes</option>
                                    <option value="30" {{ $currentReviewInterval == 30 ? 'selected' : '' }}>30 minutes</option>
                                    <option value="45" {{ $currentReviewInterval == 45 ? 'selected' : '' }}>45 minutes</option>
                                    <option value="60" {{ $currentReviewInterval == 60 ? 'selected' : '' }}>1 hour</option>
                                    <option value="custom" {{ !in_array($currentReviewInterval, [5,10,15,30,45,60]) ? 'selected' : '' }}>Custom</option>
                                </select>

                                <div id="review_custom_input" class="mt-2 {{ in_array($currentReviewInterval, [5,10,15,30,45,60]) ? 'hidden' : '' }}">
                                    <input type="number"
                                           name="review_custom_interval"
                                           id="review_custom_interval"
                                           min="1"
                                           max="1440"
                                           value="{{ !in_array($currentReviewInterval, [5,10,15,30,45,60]) ? $currentReviewInterval : '' }}"
                                           placeholder="Enter minutes (1-1440)"
                                           class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    <p class="text-xs text-gray-500 mt-1">Enter interval in minutes (1-1440)</p>
                                </div>
                            </div>
                        </div>

                        <div class="flex items-center justify-between pt-6 border-t border-gray-200 mt-6">
                            <p class="text-sm text-gray-600">
                                These settings control how often the system automatically fetches new emails and reviews for your organization.
                            </p>
                            <button type="submit"
                                    class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded">
                                Save Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
    // Mobile menu toggle
    function toggleMobileMenu() {
        const menu = document.getElementById('mobile-menu');
        const menuIcon = document.getElementById('menu-icon');
        const closeIcon = document.getElementById('close-icon');

        menu.classList.toggle('hidden');
        menuIcon.classList.toggle('hidden');
        menuIcon.classList.toggle('block');
        closeIcon.classList.toggle('hidden');
        closeIcon.classList.toggle('block');
    }

    function toggleCustomInput(type) {
        const select = document.getElementById(`${type}_interval`);
        const customInput = document.getElementById(`${type}_custom_input`);

        if (select.value === 'custom') {
            customInput.classList.remove('hidden');
        } else {
            customInput.classList.add('hidden');
        }
    }
    </script>
</body>
</html>
