<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'ReplyPilot') }} - Edit Review Draft</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- TinyMCE -->
    <script src="{{ url('tinymce/js/tinymce.min.js') }}"></script>
</head>
<body class="font-sans antialiased bg-gray-100">
    <div class="min-h-screen">
        <!-- Navigation -->
        <nav class="bg-white shadow">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <h1 class="text-xl font-semibold text-gray-900">ReplyPilot</h1>
                    </div>
                    <div class="flex items-center space-x-4">
                        <a href="{{ route('dashboard') }}" class="text-gray-700 hover:text-gray-900">Dashboard</a>
                        <a href="{{ route('reviews.index') }}" class="text-indigo-600 font-medium">Reviews</a>
                        <a href="{{ route('email.index') }}" class="text-gray-700 hover:text-gray-900">Inbox</a>
                        <form method="POST" action="{{ route('logout') }}" class="inline">
                            @csrf
                            <button type="submit" class="text-gray-700 hover:text-gray-900">Logout</button>
                        </form>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
            @if (session('success'))
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    {{ session('error') }}
                </div>
            @endif

            <div class="px-4 py-6 sm:px-0">
                <div class="flex justify-between items-center mb-6">
                    <h2 class="text-2xl font-bold text-gray-900">Edit Review Draft</h2>
                    <a href="{{ route('reviews.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                        Back to Reviews
                    </a>
                </div>

                <!-- Review Details -->
                <div class="bg-white shadow overflow-hidden sm:rounded-md mb-6">
                    <div class="px-6 py-4">
                        <div class="flex items-center space-x-3 mb-3">
                            <div class="flex items-center">
                                @for($i = 1; $i <= 5; $i++)
                                    @if($i <= $review->stars)
                                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                                        </svg>
                                    @else
                                        <svg class="w-5 h-5 text-gray-300" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                                        </svg>
                                    @endif
                                @endfor
                            </div>
                            <span class="text-sm text-gray-500">{{ $review->created_at->format('M d, Y') }}</span>
                        </div>
                        <p class="text-sm text-gray-900">{{ $review->text }}</p>
                    </div>
                </div>

                <!-- Edit Draft Form -->
                <div class="bg-white shadow overflow-hidden sm:rounded-md">
                    <div class="px-6 py-4">
                        <form method="POST" action="{{ route('reviews.update', $review) }}">
                            @csrf
                            @method('PUT')
                            
                            <div class="mb-6">
                                <label for="review-editor" class="block text-sm font-medium text-gray-700 mb-2">
                                    Draft Reply
                                </label>
                                <div class="mt-1">
                                    <textarea 
                                        id="review-editor" 
                                        name="draft_reply" 
                                        rows="10" 
                                        class="shadow-sm focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md @error('draft_reply') border-red-300 @enderror"
                                        placeholder="Enter your reply to this review..."
                                        required
                                    >{{ old('draft_reply', $draft->draft_reply) }}</textarea>
                                </div>
                                <p class="mt-2 text-sm text-gray-500">
                                    Review and edit your reply draft. Use the toolbar above the editor for formatting.
                                </p>
                                @error('draft_reply')
                                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Preview -->
                            <div class="mb-6">
                                <label class="block text-sm font-medium text-gray-700">Preview</label>
                                <div class="mt-1 border border-gray-300 rounded-md p-4 bg-gray-50 min-h-[100px]">
                                    <div id="preview" class="prose max-w-none">
                                        {!! old('draft_reply', $draft->draft_reply) !!}
                                    </div>
                                </div>
                            </div>

                            <div class="flex space-x-3">
                                <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                    Save Changes
                                </button>
                                <a href="{{ route('reviews.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                                    Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize TinyMCE
        tinymce.init({
            selector: '#review-editor',
            setup: function(editor) {
                editor.on('init', function() {
                    // Initial preview update
                    setTimeout(function() {
                        updatePreview();
                    }, 100);
                });
            }
        });
    });

    function updatePreview() {
        const preview = document.getElementById('preview');
        const textarea = document.getElementById('review-editor');
        if (preview && textarea) {
            preview.innerHTML = textarea.value;
        }
    }
    </script>
</body>
</html>
