<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'ReplyPilot') }} - Agent Reviews</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        a:hover { text-decoration: none !important; }
        a { text-decoration: none !important; }
        ul, ol, li { list-style: none !important; list-style-type: none !important; }
        li::before, li::marker { content: none !important; display: none !important; }
    </style>
</head>
<body class="font-sans antialiased bg-gray-100">
    <div class="min-h-screen">
        <!-- Navigation -->
        <nav class="bg-white shadow">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <h1 class="text-lg sm:text-xl font-semibold text-gray-900">ReplyPilot</h1>
                    </div>

                    <!-- Mobile menu button -->
                    <div class="flex items-center md:hidden">
                        <button type="button" onclick="toggleMobileMenu()" class="inline-flex items-center justify-center p-2 rounded-md text-gray-700 hover:text-gray-900 hover:bg-gray-100">
                            <svg id="menu-icon" class="block h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                            <svg id="close-icon" class="hidden h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>

                    <!-- Desktop navigation -->
                    <div class="hidden md:flex md:items-center md:space-x-4">
                        <a href="{{ route('dashboard') }}" class="text-gray-700 hover:text-gray-900 text-sm">Dashboard</a>
                        <a href="{{ \App\Helpers\RoleBasedNavigation::getReviewsIndexRoute() }}" class="text-indigo-600 font-medium text-sm">Reviews</a>
                        <a href="{{ \App\Helpers\RoleBasedNavigation::getEmailIndexRoute() }}" class="text-gray-700 hover:text-gray-900 text-sm">Inbox</a>
                        <form method="POST" action="{{ route('logout') }}" class="inline">
                            @csrf
                            <button type="submit" class="text-gray-700 hover:text-gray-900 text-sm">Logout</button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Mobile menu -->
            <div id="mobile-menu" class="hidden md:hidden">
                <div class="px-2 pt-2 pb-3 space-y-1 bg-gray-50 border-t">
                    <a href="{{ route('dashboard') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Dashboard</a>
                    <a href="{{ \App\Helpers\RoleBasedNavigation::getReviewsIndexRoute() }}" class="block px-3 py-2 rounded-md text-base font-medium text-indigo-600 bg-indigo-50">Reviews</a>
                    <a href="{{ \App\Helpers\RoleBasedNavigation::getEmailIndexRoute() }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Inbox</a>
                    <form method="POST" action="{{ route('logout') }}" class="block">
                        @csrf
                        <button type="submit" class="w-full text-left px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Logout</button>
                    </form>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
                @if (session('success'))
                    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                        {{ session('success') }}
                    </div>
                @endif

                @if (session('error'))
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                        {{ session('error') }}
                    </div>
                @endif

                @if(isset($status))
                    <div class="bg-white border border-gray-200 rounded-lg px-4 py-4 mb-6">
                        <div class="flex items-center justify-between flex-wrap gap-2">
                            <h3 class="text-sm font-semibold text-gray-900">Connection Status</h3>
                            <div class="flex items-center gap-3">
                                @if($status['oauth_connected'])
                                    <form method="POST" action="{{ route('agent.reviews.disconnect') }}" class="inline"
                                          onsubmit="return confirm('Disconnect Google Business Profile and delete imported locations/reviews?');">
                                        @csrf
                                        <button type="submit"
                                                class="text-xs text-red-600 hover:text-red-800 font-medium">
                                            Disconnect
                                        </button>
                                    </form>
                                @else
                                    <a href="{{ route('oauth.google.start') }}"
                                       class="text-xs text-blue-600 hover:text-blue-800 font-medium">
                                        Connect Google Account
                                    </a>
                                @endif
                                <span class="text-xs text-gray-500">Only reviews you imported are shown here.</span>
                            </div>
                        </div>
                        <div class="mt-3 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3 text-sm">
                            <div class="rounded-md border border-gray-100 bg-gray-50 px-3 py-2">
                                <div class="text-gray-500">Google OAuth</div>
                                <div class="font-medium text-gray-900">
                                    {{ $status['oauth_connected'] ? 'Connected' : 'Not connected' }}
                                </div>
                                @if(!empty($status['oauth_emails']))
                                    <div class="text-xs text-gray-500">{{ implode(', ', $status['oauth_emails']) }}</div>
                                @endif
                            </div>
                            <div class="rounded-md border border-gray-100 bg-gray-50 px-3 py-2">
                                <div class="text-gray-500">Locations</div>
                                <div class="font-medium text-gray-900">{{ $status['locations_count'] }}</div>
                            </div>
                            <div class="rounded-md border border-gray-100 bg-gray-50 px-3 py-2">
                                <div class="text-gray-500">Reviews</div>
                                <div class="font-medium text-gray-900">{{ $status['reviews_count'] }}</div>
                            </div>
                            <div class="rounded-md border border-gray-100 bg-gray-50 px-3 py-2">
                                <div class="text-gray-500">AI Provider</div>
                                <div class="font-medium text-gray-900">
                                    {{ $status['ai_default_name'] }}
                                    @if($status['ai_default_ready'])
                                        <span class="ml-1 text-green-600 text-xs">Ready</span>
                                    @else
                                        <span class="ml-1 text-red-600 text-xs">Not ready</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @if(!$status['oauth_connected'] || $status['locations_count'] === 0)
                            <div class="mt-3 text-xs text-gray-600">
                                Import locations and fetch reviews to see real data here.
                            </div>
                        @endif
                    </div>
                @endif

            <div class="px-4 py-6 sm:px-0">
                <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center mb-6 gap-4">
                    <h2 class="text-lg sm:text-xl font-bold text-gray-900">Reviews Management</h2>

                    <div class="flex flex-wrap items-center gap-2">
                        @if($reviews->count() > 0)
                            <button type="button"
                                    class="bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-3 rounded text-xs sm:text-sm"
                                    onclick="bulkDeleteSelectedReviews()"
                                    id="bulkDeleteBtn"
                                    disabled>
                                <span class="hidden sm:inline">Delete Selected</span>
                                <span class="sm:hidden">Delete</span>
                            </button>
                        @endif

                        <form method="POST" action="{{ route('agent.reviews.import-locations') }}" class="inline">
                            @csrf
                            <button type="submit"
                                    class="bg-green-500 hover:bg-green-700 text-white font-bold py-2 px-3 rounded text-xs sm:text-sm flex items-center"
                                    onclick="this.disabled=true; this.form.submit();">
                                <svg class="w-4 h-4 sm:mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10"></path>
                                </svg>
                                <span class="hidden sm:inline">Import</span>
                            </button>
                        </form>

                        <form method="POST" action="{{ route('agent.reviews.ingest') }}" class="inline">
                            @csrf
                            <button type="submit"
                                    class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-3 rounded text-xs sm:text-sm flex items-center"
                                    onclick="this.disabled=true; this.form.submit();">
                                <svg class="w-4 h-4 sm:mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                </svg>
                                <span class="hidden sm:inline">Fetch</span>
                            </button>
                        </form>
                    </div>
                </div>
            </div>


                @if($reviews->count() > 0)
                    <div class="bg-white shadow overflow-hidden sm:rounded-md">
                        <!-- Select All Reviews Checkbox -->
                        <div class="px-6 py-3 bg-gray-50 border-b border-gray-200">
                            <div class="flex items-center">
                                <input type="checkbox"
                                       id="masterCheckbox"
                                       class="rounded border-gray-300 text-red-600 focus:ring-red-500"
                                       onchange="toggleAllReviews()">
                                <label for="masterCheckbox" class="ml-2 text-sm font-medium text-gray-700">
                                    Select All Reviews
                                </label>
                            </div>
                        </div>

                        <!-- Reviews List -->
                        <ul class="divide-y divide-gray-200 email-list-mobile">
                            @foreach($reviews as $review)
                                <li class="px-6 py-4 review-card-mobile">
                                    <div class="flex items-center justify-between">
                                        <div class="flex items-center mr-4">
                                            <input type="checkbox"
                                                   class="review-checkbox rounded border-gray-300 text-red-600 focus:ring-red-500"
                                                   value="{{ $review->id }}"
                                                   onchange="updateBulkDeleteButton()">
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <div class="flex items-center justify-between">
                                                <div class="flex-1 min-w-0">
                                                    <div class="flex items-center space-x-2 mb-2">
                                                        <!-- Star Rating -->
                                                        <div class="flex items-center">
                                                            @for($i = 1; $i <= 5; $i++)
                                                                @if($i <= $review->stars)
                                                                    <svg class="w-4 h-4 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                                                    </svg>
                                                                @else
                                                                    <svg class="w-4 h-4 text-gray-300" fill="currentColor" viewBox="0 0 20 20">
                                                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                                                    </svg>
                                                                @endif
                                                            @endfor
                                                        </div>
                                                        <span class="text-sm text-gray-500">{{ $review->created_at->format('M j, Y') }}</span>
                                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                                            @if($review->status === 'new') bg-gray-100 text-gray-800
                                                            @elseif($review->status === 'drafted') bg-yellow-100 text-yellow-800
                                                            @elseif($review->status === 'posted') bg-green-100 text-green-800
                                                            @else bg-gray-100 text-gray-800
                                                            @endif">
                                                            {{ ucfirst($review->status) }}
                                                        </span>
                                                    </div>
                                                    <p class="text-sm text-gray-900">{{ $review->text }}</p>
                                                </div>
                                                <div class="flex items-center space-x-2">
                                                    <!-- AI Draft Button -->
                                                    @if($review->status === 'new')
                                                        <form method="POST" action="{{ route('agent.reviews.draft', $review) }}" class="inline"
                                                              onsubmit="return handleDraftSubmit(this, '{{ $review->id }}')">
                                                            @csrf
                                                            <button type="submit" id="draft-btn-{{ $review->id }}"
                                                                    class="bg-purple-500 hover:bg-purple-700 text-white font-bold py-1 px-3 rounded text-sm flex items-center">
                                                                <svg id="draft-icon-{{ $review->id }}" class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                                                                </svg>
                                                                <span id="draft-text-{{ $review->id }}">AI Draft</span>
                                                            </button>
                                                        </form>
                                                    @elseif($review->status === 'drafted')
                                                        <form method="POST" action="{{ route('agent.reviews.approve', $review) }}" class="inline"
                                                              onsubmit="return handleApproveSubmit(this, '{{ $review->id }}')">
                                                            @csrf
                                                            <button type="submit" id="approve-btn-{{ $review->id }}"
                                                                    class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-3 rounded text-sm flex items-center">
                                                                <svg id="approve-icon-{{ $review->id }}" class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                                                                </svg>
                                                                <span id="approve-text-{{ $review->id }}">Approve & Send</span>
                                                            </button>
                                                        </form>
                                                    @endif
                                                    <!-- Delete Review Button -->
                                                    <form method="POST" action="{{ route('reviews.delete', $review) }}" class="inline"
                                                          onsubmit="return handleDeleteReviewSubmit(this, '{{ $review->id }}')">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" id="delete-review-btn-{{ $review->id }}"
                                                                class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-1 px-3 rounded text-sm flex items-center">
                                                            <svg id="delete-review-icon-{{ $review->id }}" class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                            </svg>
                                                            <span id="delete-review-text-{{ $review->id }}">Delete Review</span>
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </div>

                    <div class="mt-4">
                        {{ $reviews->links() }}
                    </div>
                @else
                    <div class="text-center py-12">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/>
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900">No reviews found</h3>
                        <p class="mt-1 text-sm text-gray-500">Use the "Import Locations" and "Fetch Reviews" buttons above to get started.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <script>
        // Mobile menu toggle
        function toggleMobileMenu() {
            const menu = document.getElementById('mobile-menu');
            const menuIcon = document.getElementById('menu-icon');
            const closeIcon = document.getElementById('close-icon');

            menu.classList.toggle('hidden');
            menuIcon.classList.toggle('hidden');
            menuIcon.classList.toggle('block');
            closeIcon.classList.toggle('hidden');
            closeIcon.classList.toggle('block');
        }

        function updateBulkDeleteButton() {
            const checkboxes = document.querySelectorAll('.review-checkbox');
            const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');
            const masterCheckbox = document.getElementById('masterCheckbox');
            const checkedCount = document.querySelectorAll('.review-checkbox:checked').length;
            const totalCount = checkboxes.length;

            // Update master checkbox state
            if (masterCheckbox) {
                if (checkedCount === 0) {
                    masterCheckbox.checked = false;
                    masterCheckbox.indeterminate = false;
                } else if (checkedCount === totalCount) {
                    masterCheckbox.checked = true;
                    masterCheckbox.indeterminate = false;
                } else {
                    masterCheckbox.checked = false;
                    masterCheckbox.indeterminate = true;
                }
            }

            // Update bulk delete button
            if (checkedCount > 0) {
                bulkDeleteBtn.disabled = false;
                bulkDeleteBtn.textContent = `Delete Selected (${checkedCount})`;
            } else {
                bulkDeleteBtn.disabled = true;
                bulkDeleteBtn.textContent = 'Delete Selected';
            }
        }

        function bulkDeleteSelectedReviews() {
            const checkboxes = document.querySelectorAll('.review-checkbox:checked');
            const reviewIds = Array.from(checkboxes).map(cb => cb.value);

            if (reviewIds.length === 0) {
                alert('No reviews selected for deletion.');
                return;
            }

            const confirmMessage = `Are you sure you want to delete ${reviewIds.length} review(s)? This action cannot be undone.`;

            if (confirm(confirmMessage)) {
                // Create form and submit
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = '{{ route('agent.reviews.bulk-delete') }}';
                form.style.display = 'none';

                // Add CSRF token
                const csrfToken = document.createElement('input');
                csrfToken.type = 'hidden';
                csrfToken.name = '_token';
                csrfToken.value = '{{ csrf_token() }}';
                form.appendChild(csrfToken);

                // Add review IDs
                reviewIds.forEach(id => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'review_ids[]';
                    input.value = id;
                    form.appendChild(input);
                });

                document.body.appendChild(form);
                form.submit();
            }
        }

        function toggleAllReviews() {
            const masterCheckbox = document.getElementById('masterCheckbox');
            const checkboxes = document.querySelectorAll('.review-checkbox');

            checkboxes.forEach(checkbox => {
                checkbox.checked = masterCheckbox.checked;
            });

            updateBulkDeleteButton();
        }

        function updateBulkDeleteButton() {
            const checkboxes = document.querySelectorAll('.review-checkbox:checked');
            const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');

            if (checkboxes.length > 0) {
                bulkDeleteBtn.disabled = false;
                bulkDeleteBtn.textContent = `Delete Selected (${checkboxes.length})`;
            } else {
                bulkDeleteBtn.disabled = true;
                bulkDeleteBtn.textContent = 'Delete Selected';
            }
        }

        // Button handlers
        function handleDraftSubmit(form, reviewId) {
            const button = document.getElementById(`draft-btn-${reviewId}`);
            const icon = document.getElementById(`draft-icon-${reviewId}`);
            const text = document.getElementById(`draft-text-${reviewId}`);

            // Show loading state
            button.disabled = true;
            button.classList.add('opacity-50');
            text.textContent = 'Generating...';

            // Add spinner
            icon.innerHTML = '<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>';
            icon.classList.add('animate-spin');

            return true;
        }

        function handleApproveSubmit(form, reviewId) {
            if (!confirm('Are you sure you want to post this reply?')) {
                return false;
            }

            const button = document.getElementById(`approve-btn-${reviewId}`);
            const icon = document.getElementById(`approve-icon-${reviewId}`);
            const text = document.getElementById(`approve-text-${reviewId}`);

            // Show loading state
            button.disabled = true;
            button.classList.add('opacity-50');
            text.textContent = 'Posting...';

            // Add spinner
            icon.innerHTML = '<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>';
            icon.classList.add('animate-spin');

            return true;
        }

        function handleDeleteReviewSubmit(form, reviewId) {
            if (!confirm('Are you sure you want to delete this review? This action cannot be undone.')) {
                return false;
            }

            const button = document.getElementById(`delete-review-btn-${reviewId}`);
            const icon = document.getElementById(`delete-review-icon-${reviewId}`);
            const text = document.getElementById(`delete-review-text-${reviewId}`);

            // Show loading state
            button.disabled = true;
            button.classList.add('opacity-50');
            text.textContent = 'Deleting...';

            // Add spinner
            icon.innerHTML = '<circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>';
            icon.classList.add('animate-spin');

            return true;
        }
    </script>
</body>
</html>
