<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'ReplyPilot') }} - Email Thread</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="font-sans antialiased bg-gray-100">
    <div class="min-h-screen">
        <!-- Navigation -->
        <nav class="bg-white shadow">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <h1 class="text-xl font-semibold text-gray-900">ReplyPilot - Agent</h1>
                    </div>
                    <div class="flex items-center space-x-4">
                        <a href="{{ route('dashboard') }}" class="text-gray-700 hover:text-gray-900">Dashboard</a>
                        <a href="{{ route('reviews.index') }}" class="text-gray-700 hover:text-gray-900">Reviews</a>
                        <a href="{{ route('agent.email.index') }}" class="text-indigo-600 font-medium">Inbox</a>
                        <a href="{{ route('email.accounts') }}" class="text-gray-700 hover:text-gray-900">Accounts</a>
                        <form method="POST" action="{{ route('logout') }}" class="inline">
                            @csrf
                            <button type="submit" class="text-gray-700 hover:text-gray-900">Logout</button>
                        </form>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
            @if (session('success'))
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    {{ session('error') }}
                </div>
            @endif

            <div class="px-4 py-6 sm:px-0">
                <!-- Back Button -->
                <div class="mb-6">
                    <a href="{{ route('agent.email.index') }}" 
                       class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                        </svg>
                        Back to Inbox
                    </a>
                </div>

                <!-- Thread Header -->
                <div class="bg-white shadow rounded-lg mb-6">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h2 class="text-xl font-semibold text-gray-900">{{ $thread->subject }}</h2>
                        <div class="mt-2 flex items-center text-sm text-gray-500">
                            <span class="mr-4">From: {{ $thread->mailAccount->email }}</span>
                            <span class="mr-4">Last Message: {{ $thread->last_message_at->format('M j, Y g:i A') }}</span>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                @if($thread->status === 'open') bg-green-100 text-green-800
                                @elseif($thread->status === 'closed') bg-gray-100 text-gray-800
                                @else bg-yellow-100 text-yellow-800
                                @endif">
                                {{ ucfirst($thread->status) }}
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Messages -->
                <div class="space-y-4">
                    @foreach($thread->messages->sortBy('date') as $message)
                        <div class="bg-white shadow rounded-lg">
                            <div class="px-6 py-4 border-b border-gray-200">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                            @if($message->direction === 'inbound') bg-blue-100 text-blue-800
                                            @else bg-green-100 text-green-800
                                            @endif">
                                            {{ ucfirst($message->direction) }}
                                        </span>
                                        <span class="ml-3 text-sm font-medium text-gray-900">
                                            {{ $message->from_addr }}
                                        </span>
                                    </div>
                                    <div class="text-sm text-gray-500">
                                        {{ $message->date->format('M j, Y g:i A') }}
                                    </div>
                                </div>
                            </div>
                            
                            <div class="px-6 py-4">
                                @if($message->body_html)
                                    <div class="prose max-w-none">
                                        {!! $message->body_html !!}
                                    </div>
                                @elseif($message->body_text)
                                    <div class="whitespace-pre-wrap text-gray-700">
                                        {{ $message->body_text }}
                                    </div>
                                @else
                                    <div class="text-gray-500 italic">
                                        No content available
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Actions -->
                <div class="mt-6 flex justify-end space-x-4">
                    @if($thread->messages->count() > 0)
                        <form method="POST" action="{{ route('email.draft', $thread) }}" class="inline">
                            @csrf
                            <button type="submit"
                                    class="bg-purple-500 hover:bg-purple-700 text-white font-bold py-2 px-4 rounded">
                                Generate AI Draft
                            </button>
                        </form>
                    @endif
                    
                    <form method="POST" action="{{ route('agent.email.destroy', $thread) }}" class="inline" 
                          onsubmit="return confirm('Are you sure you want to delete this entire email thread? This will delete all messages and drafts. This action cannot be undone.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" 
                                class="bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                            Delete Thread
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
