<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Tenant;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class MultiTenantSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create default tenant
        $defaultTenant = Tenant::firstOrCreate(
            ['slug' => 'default'],
            [
                'name' => 'Default Business',
                'domain' => null,
                'settings' => [
                    'timezone' => 'UTC',
                    'date_format' => 'Y-m-d',
                    'time_format' => 'H:i:s',
                ],
                'is_active' => true,
            ]
        );

        // Update existing users to have proper roles and tenant assignments
        $existingUsers = User::all();
        
        foreach ($existingUsers as $index => $user) {
            if ($index === 0) {
                // First user becomes super admin
                $user->update([
                    'name' => 'Super Admin',
                    'role' => 'super_admin',
                    'tenant_id' => null,
                    'is_active' => true,
                    'settings' => [
                        'theme' => 'light',
                        'notifications' => true,
                    ],
                ]);
            } else {
                // Other users become tenant admins
                $user->update([
                    'name' => 'Tenant Admin',
                    'role' => 'tenant_admin',
                    'tenant_id' => $defaultTenant->id,
                    'is_active' => true,
                    'settings' => [
                        'theme' => 'light',
                        'notifications' => true,
                    ],
                ]);
            }
        }

        // Create a sample agent if we don't have enough users
        if ($existingUsers->count() < 3) {
            User::create([
                'name' => 'John Agent',
                'email' => 'john@default.com',
                'password' => Hash::make('agent123'),
                'role' => 'agent',
                'tenant_id' => $defaultTenant->id,
                'is_active' => true,
                'settings' => [
                    'theme' => 'light',
                    'notifications' => true,
                ],
            ]);
        }

        $this->command->info('Multi-tenant setup completed!');
        $this->command->info('Updated existing users with proper roles and tenant assignments.');
        $this->command->info('Default tenant created: ' . $defaultTenant->name);
    }
}
