<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('threads')) {
            if (! $this->indexExists('threads', 'threads_status_index')) {
                DB::statement('CREATE INDEX threads_status_index ON threads(status)');
            }
            if (! $this->indexExists('threads', 'threads_last_message_at_index')) {
                DB::statement('CREATE INDEX threads_last_message_at_index ON threads(last_message_at)');
            }
            if (! $this->indexExists('threads', 'threads_mail_account_id_status_index')) {
                DB::statement('CREATE INDEX threads_mail_account_id_status_index ON threads(mail_account_id, status)');
            }
        }

        if (Schema::hasTable('messages')) {
            if (! $this->indexExists('messages', 'messages_date_index')) {
                DB::statement('CREATE INDEX messages_date_index ON messages(date)');
            }
            if (! $this->indexExists('messages', 'messages_thread_id_date_index')) {
                DB::statement('CREATE INDEX messages_thread_id_date_index ON messages(thread_id, date)');
            }
            if (! $this->indexExists('messages', 'messages_direction_index')) {
                DB::statement('CREATE INDEX messages_direction_index ON messages(direction)');
            }
        }

        if (Schema::hasTable('sessions')) {
            if (! $this->indexExists('sessions', 'sessions_user_id_index')) {
                DB::statement('CREATE INDEX sessions_user_id_index ON sessions(user_id)');
            }
            if (! $this->indexExists('sessions', 'sessions_last_activity_index')) {
                DB::statement('CREATE INDEX sessions_last_activity_index ON sessions(last_activity)');
            }
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('threads')) {
            if ($this->indexExists('threads', 'threads_status_index')) {
                DB::statement('DROP INDEX threads_status_index ON threads');
            }
            if ($this->indexExists('threads', 'threads_last_message_at_index')) {
                DB::statement('DROP INDEX threads_last_message_at_index ON threads');
            }
            if ($this->indexExists('threads', 'threads_mail_account_id_status_index')) {
                DB::statement('DROP INDEX threads_mail_account_id_status_index ON threads');
            }
        }

        if (Schema::hasTable('messages')) {
            if ($this->indexExists('messages', 'messages_date_index')) {
                DB::statement('DROP INDEX messages_date_index ON messages');
            }
            if ($this->indexExists('messages', 'messages_thread_id_date_index')) {
                DB::statement('DROP INDEX messages_thread_id_date_index ON messages');
            }
            if ($this->indexExists('messages', 'messages_direction_index')) {
                DB::statement('DROP INDEX messages_direction_index ON messages');
            }
        }

        if (Schema::hasTable('sessions')) {
            if ($this->indexExists('sessions', 'sessions_user_id_index')) {
                DB::statement('DROP INDEX sessions_user_id_index ON sessions');
            }
            if ($this->indexExists('sessions', 'sessions_last_activity_index')) {
                DB::statement('DROP INDEX sessions_last_activity_index ON sessions');
            }
        }
    }

    private function indexExists(string $table, string $index): bool
    {
        $database = DB::getDatabaseName();

        $result = DB::selectOne(
            'SELECT COUNT(1) AS count FROM information_schema.statistics WHERE table_schema = ? AND table_name = ? AND index_name = ?',
            [$database, $table, $index]
        );

        return (int) ($result->count ?? 0) > 0;
    }
};
