<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add is_active column - best practice for user account management
            // Allows soft disabling of accounts without deletion
            $table->boolean('is_active')->default(true)->after('role');
            
            // Add settings column - best practice for user preferences
            // Stores user-specific settings like theme, notifications, timezone, etc.
            $table->json('settings')->nullable()->after('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['is_active', 'settings']);
        });
    }
};
