<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix collation for reviews table to support emojis and 4-byte Unicode
        DB::statement('ALTER TABLE reviews CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
        
        // Also fix the text column specifically to ensure it can handle emojis
        DB::statement('ALTER TABLE reviews MODIFY COLUMN text LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert to utf8mb3 (though this might cause data loss for emojis)
        DB::statement('ALTER TABLE reviews CONVERT TO CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci');
        DB::statement('ALTER TABLE reviews MODIFY COLUMN text LONGTEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci');
    }
};