<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add user_id and tenant_id to mail_accounts table
        Schema::table('mail_accounts', function (Blueprint $table) {
            $table->uuid('user_id')->nullable()->after('id');
            $table->unsignedBigInteger('tenant_id')->nullable()->after('user_id');

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');

            $table->index(['user_id', 'tenant_id']);
        });

        // Add user_id and tenant_id to threads table
        Schema::table('threads', function (Blueprint $table) {
            $table->uuid('user_id')->nullable()->after('id');
            $table->unsignedBigInteger('tenant_id')->nullable()->after('user_id');

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');

            $table->index(['user_id', 'tenant_id']);
        });

        // Add user_id and tenant_id to email_drafts table
        Schema::table('email_drafts', function (Blueprint $table) {
            $table->uuid('user_id')->nullable()->after('id');
            $table->unsignedBigInteger('tenant_id')->nullable()->after('user_id');

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');

            $table->index(['user_id', 'tenant_id']);
        });

        // Add user_id and tenant_id to messages table
        Schema::table('messages', function (Blueprint $table) {
            $table->uuid('user_id')->nullable()->after('id');
            $table->unsignedBigInteger('tenant_id')->nullable()->after('user_id');

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');

            $table->index(['user_id', 'tenant_id']);
        });

        // Add user_id and tenant_id to locations table
        Schema::table('locations', function (Blueprint $table) {
            $table->uuid('user_id')->nullable()->after('id');
            $table->unsignedBigInteger('tenant_id')->nullable()->after('user_id');

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');

            $table->index(['user_id', 'tenant_id']);
        });

        // Add user_id and tenant_id to oauth_connections table
        Schema::table('oauth_connections', function (Blueprint $table) {
            $table->uuid('user_id')->nullable()->after('id');
            $table->unsignedBigInteger('tenant_id')->nullable()->after('user_id');

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');

            $table->index(['user_id', 'tenant_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove foreign keys and columns
        Schema::table('mail_accounts', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['tenant_id']);
            $table->dropColumn(['user_id', 'tenant_id']);
        });

        Schema::table('threads', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['tenant_id']);
            $table->dropColumn(['user_id', 'tenant_id']);
        });

        Schema::table('email_drafts', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['tenant_id']);
            $table->dropColumn(['user_id', 'tenant_id']);
        });

        Schema::table('messages', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['tenant_id']);
            $table->dropColumn(['user_id', 'tenant_id']);
        });

        Schema::table('locations', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['tenant_id']);
            $table->dropColumn(['user_id', 'tenant_id']);
        });

        Schema::table('oauth_connections', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['tenant_id']);
            $table->dropColumn(['user_id', 'tenant_id']);
        });
    }
};
