<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('mail_accounts', function (Blueprint $table) {
            // Make oauth_connection_id nullable for SMTP accounts
            $table->foreignUuid('oauth_connection_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('mail_accounts', function (Blueprint $table) {
            // Revert back to required oauth_connection_id
            $table->foreignUuid('oauth_connection_id')->nullable(false)->change();
        });
    }
};