<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('mail_accounts', function (Blueprint $table) {
            // SMTP Configuration fields
            $table->string('connection_type')->default('oauth')->after('email'); // 'oauth' or 'smtp'
            $table->string('smtp_host')->nullable()->after('signature_html');
            $table->integer('smtp_port')->nullable()->after('smtp_host');
            $table->string('smtp_encryption')->nullable()->after('smtp_port'); // 'tls', 'ssl', 'none'
            $table->string('smtp_username')->nullable()->after('smtp_encryption');
            $table->text('smtp_password')->nullable()->after('smtp_username');
            $table->string('smtp_from_name')->nullable()->after('smtp_password');
            
            // IMAP Configuration fields (for future Phase 2)
            $table->string('imap_host')->nullable()->after('smtp_from_name');
            $table->integer('imap_port')->nullable()->after('imap_host');
            $table->string('imap_encryption')->nullable()->after('imap_port');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('mail_accounts', function (Blueprint $table) {
            $table->dropColumn([
                'connection_type',
                'smtp_host',
                'smtp_port',
                'smtp_encryption',
                'smtp_username',
                'smtp_password',
                'smtp_from_name',
                'imap_host',
                'imap_port',
                'imap_encryption'
            ]);
        });
    }
};