<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Convert messages table to utf8mb4 to handle emojis and special characters
        DB::statement("ALTER TABLE `messages` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        
        // Also convert threads table as it might contain special characters
        DB::statement("ALTER TABLE `threads` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        
        // Convert email_drafts table as it contains email content
        DB::statement("ALTER TABLE `email_drafts` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Convert back to utf8
        DB::statement("ALTER TABLE `messages` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");
        DB::statement("ALTER TABLE `threads` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");
        DB::statement("ALTER TABLE `email_drafts` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");
    }
};