<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('oauth_connections', function (Blueprint $table) {
            // Change tokens column from json to longText to handle encrypted base64 data
            $table->longText('tokens')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('oauth_connections', function (Blueprint $table) {
            // Revert back to json type
            $table->json('tokens')->nullable()->change();
        });
    }
};