<?php

namespace Database\Factories;

use App\Models\Location;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Location>
 */
class LocationFactory extends Factory
{
    protected $model = Location::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id' => null,
            'tenant_id' => null,
            'source' => 'google_gbp',
            'account_id' => fake()->uuid(),
            'location_id' => fake()->uuid(),
            'display_name' => fake()->company(),
        ];
    }
}
