<?php

namespace App\Modules\SMTP;

use Illuminate\Support\ServiceProvider;

class SMTPServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register SMTP-specific services
        $this->app->singleton('smtp.service', function ($app) {
            return new Services\SMTPService();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Load SMTP module routes
        $this->loadRoutesFrom(__DIR__ . '/Routes/smtp.php');
        
        // Load SMTP module views
        $this->loadViewsFrom(__DIR__ . '/Views', 'smtp');
        
        // Load SMTP module migrations
        $this->loadMigrationsFrom(__DIR__ . '/Database/Migrations');
    }
}
