<?php

use App\Modules\Reviews\Controllers\ReviewsController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Reviews Module Routes
|--------------------------------------------------------------------------
|
| Here is where you can register Reviews module routes for your application.
| These routes are loaded by the ReviewsServiceProvider.
|
*/

Route::middleware(['auth'])->group(function () {
    // Reviews management
    Route::get('/reviews', [ReviewsController::class, 'index'])->name('reviews.index');
    Route::get('/reviews/{review}/edit', [ReviewsController::class, 'edit'])->name('reviews.edit');
    Route::put('/reviews/{review}', [ReviewsController::class, 'update'])->name('reviews.update');
    Route::delete('/reviews/{review}', [ReviewsController::class, 'deleteReview'])->name('reviews.delete');
    
    // Reviews operations
    Route::post('/reviews/import-locations', [ReviewsController::class, 'importLocations'])->name('reviews.import-locations');
    Route::post('/reviews/ingest', [ReviewsController::class, 'ingest'])->name('reviews.ingest');
    Route::post('/reviews/{review}/draft', [ReviewsController::class, 'draft'])->name('reviews.draft');
    Route::post('/reviews/{review}/approve', [ReviewsController::class, 'approve'])->name('reviews.approve');
    Route::post('/reviews/{review}/post', [ReviewsController::class, 'post'])->name('reviews.post');
    
    // Draft management
    Route::delete('/reviews/{reviewDraft}/delete-draft', [ReviewsController::class, 'deleteDraft'])->name('reviews.draft.delete');
    
    // Bulk operations
    Route::post('/reviews/bulk', [ReviewsController::class, 'bulkDelete'])->name('reviews.bulk-delete');
});
