<?php

namespace App\Modules\Reviews;

use Illuminate\Support\ServiceProvider;

class ReviewsServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register Reviews-specific services
        $this->app->singleton('reviews.service', function ($app) {
            return new Services\ReviewsService();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Load Reviews module routes
        $this->loadRoutesFrom(__DIR__ . '/Routes/reviews.php');
        
        // Load Reviews module views
        $this->loadViewsFrom(__DIR__ . '/Views', 'reviews');
        
        // Load Reviews module migrations
        $this->loadMigrationsFrom(__DIR__ . '/Database/Migrations');
    }
}
