<?php

use App\Modules\Gmail\Controllers\GmailController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Gmail Module Routes
|--------------------------------------------------------------------------
|
| Here is where you can register Gmail module routes for your application.
| These routes are loaded by the GmailServiceProvider.
|
*/

Route::middleware(['auth'])->group(function () {
    // Gmail OAuth routes
    Route::get('/gmail/oauth/start', [GmailController::class, 'startOAuth'])->name('gmail.oauth.start');
    Route::get('/gmail/oauth/callback', [GmailController::class, 'handleCallback'])->name('gmail.oauth.callback');
    
    // Gmail email operations
    Route::get('/gmail/emails', [GmailController::class, 'index'])->name('gmail.emails.index');
    Route::post('/gmail/emails/fetch', [GmailController::class, 'fetchEmails'])->name('gmail.emails.fetch');
    Route::post('/gmail/emails/send', [GmailController::class, 'sendEmail'])->name('gmail.emails.send');
    
    // Gmail account management
    Route::get('/gmail/accounts', [GmailController::class, 'accounts'])->name('gmail.accounts.index');
    Route::post('/gmail/accounts', [GmailController::class, 'storeAccount'])->name('gmail.accounts.store');
    Route::delete('/gmail/accounts/{account}', [GmailController::class, 'deleteAccount'])->name('gmail.accounts.delete');
});
