<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tenant extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'slug',
        'domain',
        'settings',
        'is_active',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'settings' => 'array',
            'is_active' => 'boolean',
        ];
    }

    /**
     * Get the users for the tenant.
     */
    public function users()
    {
        return $this->hasMany(User::class);
    }

    /**
     * Get the mail accounts for the tenant.
     */
    public function mailAccounts()
    {
        return $this->hasManyThrough(MailAccount::class, User::class);
    }

    /**
     * Get the email drafts for the tenant.
     */
    public function emailDrafts()
    {
        return $this->hasManyThrough(EmailDraft::class, User::class);
    }

    /**
     * Get the threads for the tenant.
     */
    public function threads()
    {
        return $this->hasManyThrough(Thread::class, User::class);
    }

    /**
     * Get the locations for the tenant.
     */
    public function locations()
    {
        return $this->hasMany(Location::class);
    }

    /**
     * Scope a query to only include active tenants.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
