<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Traits\BelongsToUser;

class OauthConnection extends Model
{
    use HasUuids, BelongsToUser;

    protected $fillable = [
        'user_id',
        'tenant_id',
        'provider',
        'account_email',
        'tokens',
        'scopes',
    ];

    protected function casts(): array
    {
        return [
            'tokens' => 'encrypted:array',
            'scopes' => 'array',
        ];
    }

    /**
     * User that owns this OAuth connection
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Tenant that owns this OAuth connection
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }

    /**
     * Mail accounts using this OAuth connection
     */
    public function mailAccounts(): HasMany
    {
        return $this->hasMany(MailAccount::class);
    }
}
