<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\BelongsToUser;

class Message extends Model
{
    use HasUuids, BelongsToUser, SoftDeletes;

    protected $fillable = [
        'user_id',
        'tenant_id',
        'thread_id',
        'provider_msg_id',
        'direction',
        'from_addr',
        'to_json',
        'cc_json',
        'bcc_json',
        'date',
        'snippet',
        'body_text',
        'body_html',
        'attachments',
        'ai_tags',
    ];

    protected function casts(): array
    {
        return [
            'to_json' => 'array',
            'cc_json' => 'array',
            'bcc_json' => 'array',
            'date' => 'datetime',
            'attachments' => 'array',
            'ai_tags' => 'array',
        ];
    }

    /**
     * User that owns this message
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Tenant that owns this message
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }

    /**
     * Thread this message belongs to
     */
    public function thread(): BelongsTo
    {
        return $this->belongsTo(Thread::class);
    }

    /**
     * Email drafts that reply to this message
     */
    public function emailDrafts(): HasMany
    {
        return $this->hasMany(EmailDraft::class, 'in_reply_to_message_id');
    }
}
