<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BulkDeleteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'review_ids' => [
                'required',
                'array',
                'min:1',
            ],
            'review_ids.*' => [
                'required',
                'string',
                'uuid',
            ],
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'review_ids.required' => 'Please select at least one review to delete.',
            'review_ids.array' => 'Invalid selection format.',
            'review_ids.min' => 'Please select at least one review to delete.',
            'review_ids.*.uuid' => 'Invalid review ID format.',
        ];
    }
}
