<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use App\Models\Tenant;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    /**
     * Display settings page for super admin
     */
    public function index()
    {
        return view('super-admin.settings.index');
    }

    /**
     * Update auto-ingestion interval settings
     */
    public function updateIngestionInterval(Request $request)
    {
        $request->validate([
            'email_interval' => 'required|string',
            'email_custom_interval' => 'nullable|integer|min:1|max:1440',
            'review_interval' => 'required|string',
            'review_custom_interval' => 'nullable|integer|min:1|max:1440',
        ]);

        // Determine final email interval
        $emailInterval = $request->email_interval === 'custom'
            ? $request->email_custom_interval
            : (int) $request->email_interval;

        // Determine final review interval
        $reviewInterval = $request->review_interval === 'custom'
            ? $request->review_custom_interval
            : (int) $request->review_interval;

        // Super admin sets global default settings
        // Store in config/cache or environment - for now using first tenant as default
        $defaultTenant = Tenant::first();

        if ($defaultTenant) {
            $settings = $defaultTenant->settings ?? [];
            $settings['email_ingestion_interval'] = $emailInterval;
            $settings['review_ingestion_interval'] = $reviewInterval;
            $defaultTenant->update(['settings' => $settings]);
        }

        return redirect()
            ->route('super-admin.settings.index')
            ->with('success', 'Auto-ingestion interval settings updated successfully!');
    }
}
