<?php

namespace App\Console\Commands;

use App\Models\MailAccount;
use Illuminate\Console\Command;

class CheckAccountsCommand extends Command
{
    protected $signature = 'check:accounts';
    protected $description = 'Check mail accounts in database';

    public function handle()
    {
        $accounts = MailAccount::with('oauthConnection')->get();
        
        $this->info('Mail Accounts:');
        foreach ($accounts as $account) {
            $this->line(sprintf(
                '%s (ID: %s, Primary: %s, OAuth: %s)',
                $account->email,
                $account->id,
                $account->is_primary ? 'Yes' : 'No',
                $account->oauthConnection ? $account->oauthConnection->account_email : 'None'
            ));
        }
        
        return 0;
    }
}
