# Windows Task Scheduler Setup for ReplyPilot

This document provides step-by-step instructions for setting up automated email and review ingestion using Windows Task Scheduler with WAMP.

## Overview

You need to set up **2 scheduled tasks**:
1. **Laravel Scheduler** - Runs every minute to check for scheduled tasks
2. **Laravel Queue Worker** - Runs continuously to process background jobs

## Prerequisites

- WAMP Server installed
- ReplyPilot application installed at: `C:\Users\iyall\OneDrive\Documents\AI\claude\replypilot`
- PHP located at: `D:\wamp\bin\php\php8.3.25\php.exe`

---

## Task 1: Laravel Scheduler (Every Minute)

### Step-by-Step Instructions

#### 1. Open Task Scheduler
- Press **Windows Key + R**
- Type: `taskschd.msc`
- Press **Enter**

#### 2. Create New Task
- Click **"Create Task..."** (NOT "Create Basic Task")

#### 3. General Tab
- **Name**: `Laravel Scheduler - ReplyPilot`
- **Description**: `Runs Laravel task scheduler every minute for ReplyPilot app`
- **Security options**:
  - ☑ Run whether user is logged on or not
  - ☑ Run with highest privileges
- **Configure for**: Windows 10

#### 4. Triggers Tab
- Click **"New..."**
- **Begin the task**: On a schedule
- **Settings**: Daily
- **Start**: Today at 12:00:00 AM
- **Recur every**: 1 days
- **Advanced settings**:
  - ☑ Repeat task every: **1 minute**
  - for a duration of: **Indefinitely**
  - ☑ Stop task if it runs longer than: **30 minutes**
  - ☑ Enabled
- Click **OK**

#### 5. Actions Tab
- Click **"New..."**
- **Action**: Start a program
- **Program/script**:
  ```
  D:\wamp\bin\php\php8.3.25\php.exe
  ```
- **Add arguments**:
  ```
  artisan schedule:run
  ```
- **Start in**:
  ```
  C:\Users\iyall\OneDrive\Documents\AI\claude\replypilot
  ```
- Click **OK**

#### 6. Conditions Tab
- ☐ UNCHECK "Start the task only if the computer is on AC power"
- ☐ UNCHECK "Stop if the computer switches to battery power"

#### 7. Settings Tab
- ☑ Allow task to be run on demand
- ☑ Run task as soon as possible after a scheduled start is missed
- **If the task fails, restart every**: 1 minute
- **Attempt to restart up to**: 3 times
- ☑ Stop the task if it runs longer than: 30 minutes
- ☑ If the running task does not end when requested, force it to stop
- **If the task is already running**: Do not start a new instance

#### 8. Save
- Click **OK**
- Enter your Windows password when prompted

#### 9. Test
- Right-click the task
- Click **"Run"**
- Refresh after 10 seconds
- Check "Last Run Result" = 0x0 (success)

---

## Task 2: Queue Worker (Continuous)

### Step-by-Step Instructions

#### 1. Create Second Task
- In Task Scheduler, click **"Create Task..."**

#### 2. General Tab
- **Name**: `Laravel Queue Worker - ReplyPilot`
- **Description**: `Runs Laravel queue worker for background jobs`
- **Security options**:
  - ☑ Run whether user is logged on or not
  - ☑ Run with highest privileges

#### 3. Triggers Tab
- Click **"New..."**
- **Begin the task**: At startup
- ☑ Enabled
- Click **OK**

#### 4. Actions Tab
- Click **"New..."**
- **Program/script**:
  ```
  D:\wamp\bin\php\php8.3.25\php.exe
  ```
- **Add arguments**:
  ```
  artisan queue:work --daemon --tries=3 --timeout=300 --sleep=3
  ```
- **Start in**:
  ```
  C:\Users\iyall\OneDrive\Documents\AI\claude\replypilot
  ```
- Click **OK**

#### 5. Conditions Tab
- ☐ UNCHECK "Start the task only if the computer is on AC power"
- ☐ UNCHECK "Stop if the computer switches to battery power"

#### 6. Settings Tab
- ☑ Allow task to be run on demand
- ☐ UNCHECK "Stop the task if it runs longer than..." (runs indefinitely)
- ☑ If the running task does not end when requested, force it to stop
- **If the task is already running**: Do not start a new instance

#### 7. Save and Start
- Click **OK**
- Enter your Windows password
- Right-click the task
- Click **"Run"** to start immediately

---

## Verification

### Check Scheduled Tasks
```bash
php artisan schedule:list
```

Expected output:
```
0    2 * * *   email:cleanup-old .................. Next Due: XX hours from now
*/15 * * * *   emails:ingest-all .................. Next Due: X minutes from now
*/15 * * * *   reviews:ingest-all ................. Next Due: X minutes from now
```

### Check Queue Worker is Running
Open Task Manager (Ctrl+Shift+Esc):
- Go to **"Details"** tab
- Look for `php.exe` process
- Should see one php.exe process running continuously

### Check Logs
Check that tasks are running:

```bash
# View scheduler log
type storage\logs\email-ingestion.log
type storage\logs\review-ingestion.log

# View Laravel log
tail -f storage\logs\laravel.log
```

### Monitor Jobs
```bash
# Check jobs in queue
php artisan queue:monitor

# View failed jobs
php artisan queue:failed
```

---

## Troubleshooting

### Scheduler Not Running
1. Open Task Scheduler
2. Find "Laravel Scheduler - ReplyPilot"
3. Check "Last Run Time" and "Last Run Result"
4. If result is not 0x0:
   - Right-click task → Properties → History tab
   - Look for error details

### Queue Worker Not Processing Jobs
1. Check if queue worker task is running:
   - Open Task Manager
   - Look for php.exe in Details tab
2. If not running:
   - Right-click "Laravel Queue Worker" task
   - Click "Run"
3. Check logs:
   ```bash
   tail -20 storage\logs\laravel.log
   ```

### Common Issues

**Issue: Task shows as "Running" but nothing happens**
- The task may be stuck
- Solution: Right-click → End
- Then right-click → Run

**Issue: "The operation completed successfully (0x0)" but no logs**
- Check Start In path is correct
- Verify PHP path is correct
- Test manually:
  ```bash
  cd C:\Users\iyall\OneDrive\Documents\AI\claude\replypilot
  D:\wamp\bin\php\php8.3.25\php.exe artisan schedule:run
  ```

**Issue: Queue worker keeps stopping**
- Check Settings tab
- Ensure "Stop the task if it runs longer than..." is UNCHECKED
- Verify server has enough resources (RAM, CPU)

---

## What Happens Now

Once both tasks are set up and running:

### Every Minute:
- Laravel Scheduler checks for tasks to run
- Logs to `storage/logs/laravel.log`

### Every 15 Minutes (at :00, :15, :30, :45):
- **`emails:ingest-all`** command runs
  - Dispatches 6 email ingestion jobs to queue
  - Logs to `storage/logs/email-ingestion.log`

- **`reviews:ingest-all`** command runs
  - Dispatches 1 review ingestion job to queue
  - Logs to `storage/logs/review-ingestion.log`

### Queue Worker (Continuous):
- Processes jobs in the background
- Fetches emails from Gmail
- Fetches reviews from Google Business Profile
- Retries failed jobs up to 3 times
- Logs all activity to `storage/logs/laravel.log`

---

## Maintenance Commands

### Restart Queue Worker
If you make code changes, restart the queue worker:
```bash
# In Task Scheduler:
# 1. Right-click "Laravel Queue Worker - ReplyPilot"
# 2. Click "End"
# 3. Right-click again → "Run"
```

### Clear Old Jobs
```bash
# Clear all jobs from queue
php artisan queue:clear

# Flush failed jobs
php artisan queue:flush

# Prune old failed jobs (older than 48 hours)
php artisan queue:prune-failed --hours=48
```

### Manual Testing
```bash
# Test scheduler manually
php artisan schedule:run

# Test email ingestion
php artisan emails:ingest-all

# Test review ingestion
php artisan reviews:ingest-all

# Process one job manually
php artisan queue:work --once
```

---

## Success Indicators

✅ **Everything is working if you see:**

1. **In Task Scheduler:**
   - "Laravel Scheduler" - Last Run Time updates every minute
   - "Laravel Queue Worker" - Status shows "Running"

2. **In Logs:**
   - `storage/logs/email-ingestion.log` - Shows "Dispatched X jobs" every 15 min
   - `storage/logs/review-ingestion.log` - Shows "Dispatched X jobs" every 15 min
   - `storage/logs/laravel.log` - Shows "Successfully completed" messages

3. **In Database:**
   - New emails appearing in `threads` and `messages` tables
   - New reviews appearing in `reviews` table
   - `jobs` table shows jobs being processed (should be mostly empty)
   - `failed_jobs` table is empty (or has minimal entries)

---

## Need Help?

If you encounter issues:
1. Check `storage/logs/laravel.log` for errors
2. Run commands manually to test
3. Verify PHP and project paths are correct
4. Ensure WAMP server is running
5. Check Windows Event Viewer for task scheduler errors

---

**Last Updated:** 2025-10-21
**Created By:** Claude Code
