# ReplyPilot

A single-tenant Laravel application for AI-powered reply management for Google Business Profile reviews and Gmail emails with human-in-the-loop approval.

## Features

- **Google Business Profile Reviews**: Fetch reviews → AI draft reply → human approves → post reply to Google
- **Gmail Email Assistant**: Fetch inbox threads → AI draft email → human approves → send reply in thread
- **Human-in-the-Loop**: Never auto-posts/sends - always requires human approval
- **Multi-modal AI**: Supports ChatGPT, Anthropic, and Gemini APIs (default Gemini)
- **Role-based Access**: Admin and agent roles with different permissions
- **Escalation System**: Automatic detection of sensitive content requiring admin approval

## Requirements

- PHP 8.2+
- Laravel 12
- MySQL/PostgreSQL
- Composer
- Node.js & NPM (for frontend assets)

## Installation

### 1. Clone and Install Dependencies

```bash
composer create-project laravel/laravel replypilot
cd replypilot
composer require google/apiclient openai-php/client
php artisan queue:table
php artisan migrate
```

### 2. Configure Environment

Copy `.env.example` to `.env` and configure:

```env
APP_NAME=ReplyPilot
APP_URL=http://localhost

# OpenAI Configuration
OPENAI_API_KEY=sk-your-openai-api-key
OPENAI_MODEL=gpt-4o-mini

# Google OAuth Configuration
GOOGLE_CLIENT_ID=your-google-client-id
GOOGLE_CLIENT_SECRET=your-google-client-secret
GOOGLE_REDIRECT_URI=${APP_URL}/oauth/google/callback
GOOGLE_ALLOWED_SCOPES=https://www.googleapis.com/auth/gmail.readonly,https://www.googleapis.com/auth/gmail.send,https://www.googleapis.com/auth/business.manage

# Optional Branding
APP_BRAND_NAME="Your Business"
APP_BRAND_LOGO_URL=""
```

### 3. Run Installation Command

```bash
php artisan app:install
```

This will:
- Run database migrations
- Create an admin user account
- Display next steps

### 4. Set Up Google Cloud Console

1. Go to [Google Cloud Console](https://console.cloud.google.com/)
2. Create a new project or select existing one
3. Enable the following APIs:
   - Gmail API
   - Google My Business API
4. Create OAuth 2.0 credentials:
   - Application type: Web application
   - Authorized redirect URIs: `http://localhost/oauth/google/callback`
5. Copy Client ID and Client Secret to your `.env` file

### 5. Start Queue Worker

```bash
php artisan queue:work
```

### 6. Set Up Cron Job (Optional)

Add to your crontab for automated data fetching:

```bash
* * * * * cd /path/to/replypilot && php artisan schedule:run >> /dev/null 2>&1
```

## Usage

### 1. Connect Google Account

1. Visit your application URL
2. Log in with your admin account
3. Click "Connect Google Account" on the dashboard
4. Authorize the required permissions

### 2. Add Business Locations

1. Go to Reviews section
2. Add your Google Business Profile locations manually (account ID and location ID)
3. Use "Ingest Reviews" to fetch reviews from Google

### 3. Manage Reviews

1. View all reviews in the Reviews section
2. Click "AI Draft" to generate a reply
3. Review the draft and click "Approve" (admin only)
4. Click "Post" to publish the reply to Google (admin only)

### 4. Manage Emails

1. Go to Inbox section
2. Use "Ingest Inbox" to fetch recent Gmail messages
3. Click "AI Draft" on any thread to generate a reply
4. Review and click "Approve & Send" (admin only)

## API Endpoints

### Google OAuth
- `GET /oauth/google/start` - Start OAuth flow
- `GET /oauth/google/callback` - Handle OAuth callback

### Reviews
- `GET /reviews` - List reviews
- `POST /reviews/ingest` - Fetch reviews from Google
- `POST /reviews/{review}/draft` - Generate AI draft
- `POST /reviews/{review}/approve` - Approve draft (admin only)
- `POST /reviews/{review}/post` - Post reply (admin only)

### Emails
- `GET /inbox` - List email threads
- `POST /inbox/ingest` - Fetch emails from Gmail
- `POST /threads/{thread}/draft` - Generate AI draft
- `POST /drafts/{draft}/approve` - Approve and send (admin only)

## Database Schema

The application uses UUID primary keys and includes the following main tables:

- `users` - User accounts with roles
- `oauth_connections` - Google OAuth tokens (encrypted)
- `locations` - Google Business Profile locations
- `reviews` - Customer reviews
- `review_drafts` - AI-generated review replies
- `mail_accounts` - Email accounts
- `threads` - Email conversation threads
- `messages` - Individual email messages
- `email_drafts` - AI-generated email replies

## Security Features

- Encrypted OAuth token storage
- Role-based access control
- Escalation keyword detection
- No logging of message bodies
- Automatic token refresh

## Guardrails

- Never auto-post/send (always human approval required)
- Word limits: Reviews ≤ 80 words, Emails ≤ 120 words
- Escalation keywords trigger admin-only approval
- Comprehensive error handling and logging

## Development

### Running Tests

```bash
php artisan test
```

### Code Style

```bash
./vendor/bin/pint
```

## Troubleshooting

### Common Issues

1. **Google OAuth errors**: Check your redirect URI matches exactly
2. **Queue not processing**: Ensure queue worker is running
3. **AI generation fails**: Verify OpenAI API key is valid
4. **Database errors**: Check migration status with `php artisan migrate:status`

### Logs

Check Laravel logs in `storage/logs/laravel.log` for detailed error information.

## License

This project is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).

## Support

For support and questions, please check the Laravel documentation or create an issue in the project repository.