# Email Cleanup - Automated System Setup

## Overview
This system automatically deletes old ingested emails to prevent junk mail accumulation and keep the database clean.

## Files Created (DO NOT MODIFY EXISTING CODE)
- `app/Console/Commands/CleanupOldEmails.php` - The cleanup command
- `app/Console/Kernel.php` - Laravel scheduler setup  
- `config/email_cleanup.php` - Configuration file
- `EMAIL_CLEANUP_SETUP.md` - This documentation

## How It Works

### Cleanup Criteria
The system will delete:
1. **Threads older than X hours** that have:
   - No active drafts (or only old drafts)
   - No recent activity (last interaction older than X hours)
2. **Orphaned messages** (messages without associated threads)

### Protection Rules
Won't delete:
- Threads with recent drafts or replies (within retention period)
- Threads that have been manually interacted with recently
- Messages associated with active threads

## Configuration

### Default Settings
- **Retention Period**: 24 hours (configurable)
- **Schedule**: Daily at 2:00 AM
- **Database Impact**: Safely removes old records only

### Environment Variables
Add to your `.env` file:
```bash
EMAIL_RETENTION_HOURS=24
```

### Command Options
```bash
# Use default 24-hour retention
php artisan email:cleanup-old

# Custom retention period (e.g., 48 hours)
php artisan email:cleanup-old --retention=48

# Extended retention (e.g., 1 week)
php artisan email:cleanup-old --retention=168
```

## Setup Instructions

### Development/Testing
Manual testing (no scheduler needed):
```bash
cd replypilot
php artisan email:cleanup-old --retention=24
```

### Production Setup
1. **Start Laravel Scheduler**:
   ```bash
   cd replypilot
   php artisan schedule:work
   ```

2. **Or Setup System Cron** (Linux/Mac):
   ```bash
   # Add to crontab - edit with: crontab -e
   * * * * * cd /path/to/your/project/replypilot && php artisan schedule:run >> /dev/null 2>&1
   ```

3. **Windows Task Scheduler**:
   - Create new task to run every minute
   - Command: `php artisan schedule:run`
   - Working directory: `C:\path\to\replypilot`

## Monitoring

### Check Schedule Status
```bash
php artisan schedule:list
```

### View Recent Runs
```bash
# Check Laravel logs
tail -f storage/logs/laravel.log | grep "CleanupOldEma"
```

### Manual Test Run
```bash
# Test with safe 7-day retention (won't delete recent emails)
php artisan email:cleanup-old --retention=168
```

## Safety Features

### No Data Loss Risk
- Only deletes emails older than specified retention period
- Protects threads with recent activity
- Safe dry-run behavior (shows what would be deleted)

### Configurable Retention
- Default: 24 hours
- Maximum recommended: 168 hours (1 week)
- Minimum recommended: 12 hours

### Logging
- All deletion operations are logged
- Shows summary of deleted records
- Safe to run multiple times

## Troubleshooting

### Command Not Found
Ensure you're in the correct directory:
```bash
cd replypilot
php artisan email:cleanup-old
```

### Permission Issues
```bash
# Fix storage permissions
chmod -R 755 storage/
chmod -R 755 bootstrap/cache/
```

### Schedule Not Running
Check Laravel scheduler:
```bash
php artisan schedule:list
```

## Configuration Files Reference

### Retention Settings
```php
// config/email_cleanup.php
'retention_period' => env('EMAIL_RETENTION_HOURS', 24),
```

### Schedule Settings  
```php
// app/Console/Kernel.php
$schedule->command('email:cleanup-old')
         ->dailyAt('02:00')
         ->withoutOverlapping()
         ->runInBackground();
```

## Future Enhancements (Not Implemented)
- User-configurable retention periods per account
- Selective cleanup based on email importance
- Advanced logging and statistics
- Web dashboard for monitoring cleanup activity
